from machine import Pin
import time

# ==== ピン設定 ====
pins = [
    ("4(GP3)", Pin(3, Pin.IN, Pin.PULL_UP)),
    ("3(GP2)", Pin(2, Pin.IN, Pin.PULL_UP)),
    ("2(GP1)", Pin(1, Pin.IN, Pin.PULL_UP)),
    ("1(GP0)", Pin(0, Pin.IN, Pin.PULL_UP)),
]

def hl(v):
    return "H" if v else "L"

print("スイッチ状態（放置=H / ONで=L）")
print("Ctrl+Cで停止")

prev_states = ["?"] * len(pins)

try:
    while True:
        states = [hl(pin.value()) for _, pin in pins]
        if states != prev_states:
            line = "  ".join([f"{name}:{state}" for (name, _), state in zip(pins, states)])
            print(line)
            prev_states = states
        time.sleep(0.1)
except KeyboardInterrupt:
    print("終了しました。")
