from machine import Pin
import time

# ==== GPIO設定 ====
SW1_PINS = [Pin(i, Pin.IN, Pin.PULL_UP) for i in (0,1,2,3)]
SW2_PINS = [Pin(i, Pin.IN, Pin.PULL_UP) for i in (4,5,6,7)]

def read_switch(pins):
    """4ビットを整数値で返す（MSB:最高位ビット）"""
    value = 0
    for bit, p in enumerate(pins):
        # p.value() は High=1, Low=0（GNDで0）
        value |= (p.value() & 1) << bit
    return value

def get_operation():
    print("演算を選択してください:")
    print(" 1: 加算 (+)")
    print(" 2: 減算 (-)")
    print(" 3: 乗算 (*)")
    print(" 4: 除算 (/)")
    while True:
        sel = input("番号を入力→ ").strip()
        if sel in ("1","2","3","4"):
            return int(sel)
        print("1〜4を入力してください。")

# ==== メイン ====
while True:
    op = get_operation()
    a = read_switch(SW1_PINS)
    b = read_switch(SW2_PINS)

    if op == 1:
        result = a + b
        symbol = "+"
    elif op == 2:
        result = a - b
        symbol = "-"
    elif op == 3:
        result = a * b
        symbol = "*"
    else:
        # bが0の場合の保護
        if b == 0:
            print("除算エラー: 0で割れません")
            continue
        result = a // b      # 整数除算
        symbol = "/"

    print("\n==== 計算結果 ====")
    print("SW1 : {:04b} ({})".format(a, a))
    print("SW2 : {:04b} ({})".format(b, b))
    print("演算 : {} {} {} = {:b} (10進:{})".format(a, symbol, b, result, result))
    print("==================\n")
    time.sleep(10)

