from machine import Pin, PWM
import time

# ----- 設定 -----
FREQ = 1000          # 1 kHz
DUTY = 10000         # おおよそ 15 % (65535 * 0.3)

# ----- PWM初期化 -----
led16 = PWM(Pin(16))
led17 = PWM(Pin(17))
led16.freq(FREQ)
led17.freq(FREQ)

# 明るさを設定
led16.duty_u16(DUTY)
led17.duty_u16(DUTY)

# 10秒間点灯
time.sleep(10)

# ----- 後処理 -----
led16.deinit()
led17.deinit()
