from machine import Pin, PWM
import time

# ----- 設定 -----
FREQ = 100
DUTY = 1000  # 約15%の明るさ（0〜65535）
pins = [21, 22, 26, 27]

# ----- PWM初期化 -----
leds = []
for p in pins:
    pwm = PWM(Pin(p))
    pwm.freq(FREQ)
    pwm.duty_u16(DUTY)
    leds.append(pwm)

# 10秒間点灯
time.sleep(10)

# ----- 後処理（完全消灯）-----
# PWMを停止して、ピンをLOW出力に戻す
for pwm in leds:
    pwm.duty_u16(0)
    pwm.deinit()

for p in pins:
    Pin(p, Pin.IN, Pin.PULL_DOWN)

time.sleep(0.01)