from machine import Pin
import time

# ----- LEDピン設定 -----
pins = [16, 17]
leds = [Pin(p, Pin.OUT) for p in pins]

# ----- メインループ -----
for i in range(len(leds)):
    # すべて消灯
    for led in leds:
        led.value(0)
    
    # 対象のLEDを点灯
    leds[i].value(1)
    print("LED", i+1, "が点灯中")  # 状態確認用
    
    # 0.5秒待機
    time.sleep(0.5)

# ----- 終了処理 -----
for led in leds:
    led.value(0)
print("1周してすべて消灯しました。")
