from machine import Pin, PWM
import time

# ===== 設定 =====
# グループA（PWM出力）
FREQ_A = 1000        # 周波数(Hz)
DUTY_A16 = 5000      # GP16の明るさ (0〜65535)
DUTY_A17 = 5000     # GP17の明るさ (0〜65535)
A_ON_TIME = 10       # GP16/17 を出力する時間 (秒)

# グループB（PWM出力）※個別設定対応
FREQ_B = 1000        # 周波数(Hz)
DUTY_B = {
    21: 5000,        # GP21
    22: 5000,       # GP22
    26: 5000,       # GP26
    27: 5000        # GP27
}
B_ON_TIME = 5        # 同時点灯する時間 (秒)

# ===== グループA初期化 =====
led16 = PWM(Pin(16))
led17 = PWM(Pin(17))

led16.freq(FREQ_A)
led17.freq(FREQ_A)
led16.duty_u16(DUTY_A16)
led17.duty_u16(DUTY_A17)

# フェーズ1：GP16/17を出力
time.sleep(A_ON_TIME)

# ===== グループA停止（確実に消灯）=====
led16.deinit()
led17.deinit()
Pin(16, Pin.OUT).value(0)
Pin(17, Pin.OUT).value(0)

# ===== グループB初期化（PWM化）=====
pwms_B = []
for p, duty in DUTY_B.items():
    pwm = PWM(Pin(p))
    pwm.freq(FREQ_B)
    pwm.duty_u16(duty)
    pwms_B.append(pwm)

# フェーズ2：GP21/22/26/27を個別DUTYで出力
time.sleep(B_ON_TIME)

# ===== 終了処理：すべて停止・消灯 =====
for pwm in pwms_B:
    pwm.deinit()

for p in DUTY_B.keys():
    Pin(p, Pin.OUT).value(0)
