from machine import Pin, PWM
import time

# GP28 をPWM出力に設定
pwm = PWM(Pin(28))
pwm.freq(50000)           # 50 kHz（推奨スタート）
pwm.duty_u16(32768)       # デューティ50%（0..65535）

# 明るさテスト：デューティをゆっくり上下させる
try:
    while True:
        # 25% → 75% へ
        for d in range(16384, 49152, 1024):
            pwm.duty_u16(d)
            time.sleep(0.02)
        # 75% → 25% へ
        for d in range(49152, 16384, -1024):
            pwm.duty_u16(d)
            time.sleep(0.02)
except KeyboardInterrupt:
    pwm.deinit()
