from machine import Pin, PWM
import time

# GP28をPWMに設定
pwm = PWM(Pin(28))
pwm.duty_u16(32768)   # 50% デューティで矩形波

# 観察する周波数リスト（低い〜高いまで）
freqs = [50000, 100000, 150000, 200000, 250000, 500000]

for f in freqs:
    pwm.freq(f)
    print("PWM周波数 =", f, "Hz")
    time.sleep(3)   # 3秒ごとに周波数切替

# 実験終了後は消灯
pwm.deinit()


# ④RLC共振回路確認用
# A/B 比較（共振付近 vs 離れた周波数を交互に出す）
# f_ref を 2 kHz / 10 kHz / 20 kHz と変えて、目で差が一番見えるペアを探す
