from machine import Pin, PWM
import time, math

# ----- 回路パラメータ（書き換え可） -----
L_H = 10e-3       # 10 mH
C_F = 0.1e-6      # 0.1 uF

# 並列共振周波数（理想LC）
f0 = int(1.0 / (2 * math.pi * math.sqrt(L_H * C_F)))  # ≈ 5033 Hz

# 比較用（共振より十分離れた周波数）
f_low  = max(100, int(f0 // 5))    # 低め（例: ≈1 kHz）
f_high = int(f0 * 5)               # 高め（例: ≈25 kHz）

# ----- PWM設定 -----
pwm = PWM(Pin(28))
pwm.duty_u16(32768)  # 50% Duty（平均電圧一定）

def show(freq, sec=3):
    pwm.freq(freq)
    print("PWM周波数 =", freq, "Hz")
    time.sleep(sec)

print("並列共振周波数(理論) f0 ≈", f0, "Hz")

try:
    while True:
        # A/B比較：共振 → 低め → 共振 → 高め
        show(f0, 3)     # 共振付近：並列回路のインピーダンス最大 → LEDが暗くなるはず
        show(f_low, 3)  # 離れた周波数：インピーダンス低下 → LEDが明るく
        show(f0, 3)
        show(f_high, 3)
except KeyboardInterrupt:
    pass
finally:
    pwm.deinit()
