from machine import Pin, time_pulse_us
import time

# ピン設定
TRIG = Pin(19, Pin.OUT)
ECHO = Pin(18, Pin.IN)

# PICOのGP20から3.3Vを出力（昇圧モジュールに供給）
VOUT = Pin(20, Pin.OUT)
VOUT.value(1)   # 常時High出力

# 距離計算用 音速 [m/s]
SPEED_OF_SOUND = 343.2

def measure_distance():
    # トリガーを送信（>10us High）
    TRIG.value(0)
    time.sleep_us(2)
    TRIG.value(1)
    time.sleep_us(15)
    TRIG.value(0)

    # Echoパルス幅を計測
    duration = time_pulse_us(ECHO, 1, 30000)  # 最大30ms待つ（~5m相当）
    if duration < 0:
        return None  # タイムアウト時

    # 時間[µs] → 秒 に換算
    duration_s = duration / 1_000_000.0

    # 距離計算（片道なので /2）
    distance_m = (duration_s * SPEED_OF_SOUND) / 2
    return distance_m * 100  # cmに変換

# 繰り返し測定
while True:
    dist = measure_distance()
    if dist is None:
        print("Timeout")
    else:
        print("距離: {:.1f} cm".format(dist))
    time.sleep(0.5)  # 0.5秒おきに測定
